---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-Application Detail（アプリケーション詳細）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/deploy/master/ui/ApplicationPage.scala`（169行）
- E-02: `core/src/main/scala/org/apache/spark/deploy/master/ui/MasterWebUI.scala`（135行）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/app/?appId={appId}` | E-01 (31行目: `WebUIPage("app")`), (37行目: `request.getParameter("appId")`) | ○ |
| C-02 | MasterStateからactiveApps/completedAppsを検索 | E-01 (38-40行目) | ○ |
| C-03 | アプリ未発見時は"Not Found"ページを返す | E-01 (41-43行目) | ○ |
| C-04 | 全エグゼキュータはexecutors.values + removedExecutorsの重複排除 | E-01 (48行目: `.toSet.toSeq`) | ○ |
| C-05 | 実行中/EXITEDはExecutor Summary、残りはRemoved Executors | E-01 (50-53行目) | ○ |
| C-06 | エグゼキュータテーブルのカラム: ExecutorID, Worker, Cores, Memory, Resource Profile Id, Resources, State, Logs | E-01 (46-47行目) | ○ |
| C-07 | Removed Executorsセクションは存在する場合のみ表示 | E-01 (129行目: `if (removedExecutors.nonEmpty)`) | ○ |
| C-08 | ワーカーリンクはreverseProxy対応 | E-01 (149-150行目: `UIUtils.makeHref(parent.master.reverseProxy...)`) | ○ |
| C-09 | ログリンクはstdoutとstderrの2つ | E-01 (162-165行目) | ○ |
| C-10 | Application Detail UIリンクは実行中かつUIあり時に表示 | E-01 (96-103行目) | ○ |
| C-11 | Application History UIリンクは完了かつhistoryServerUrl設定時に表示 | E-01 (105-109行目) | ○ |
| C-12 | UIが無効の場合は"Disabled"と表示 | E-01 (97-98行目: `<li><strong>Application UI:</strong> Disabled</li>`) | ○ |
| C-13 | Executor Limitのツールチップ表示 | E-01 (75-76行目: `ToolTips.APPLICATION_EXECUTOR_LIMIT`) | ○ |
| C-14 | Cores表示はmaxCoresの有無で分岐 | E-01 (65-72行目) | ○ |
| C-15 | ページタイトルは"Application: {name}" | E-01 (145行目) | ○ |
| C-16 | 画面遷移元はMaster Overview | E-05 (MasterOverview --> MasterAppDetail) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ExecutorState.isFinished の判定ロジックが正確か確認
- [ ] ログリンクのURLパラメータが正しいか確認
